//	}`j^[̏擾vO
//	Visual C++ 2013 32/64bit

#include <windows.h>
#include <stdio.h>
#if _MSC_VER>1500
#include <shellscalingapi.h>
#endif
#include <tchar.h>

#ifndef _DPI_AWARENESS_CONTEXTS_
DECLARE_HANDLE(DPI_AWARENESS_CONTEXT);
#endif

typedef HRESULT(_stdcall* EnableNonClientDpiScalingFunc)(HWND);
typedef HRESULT(_stdcall* SetThreadDpiAwarenessContextFunc)(DPI_AWARENESS_CONTEXT);

HMODULE hModUser32 = 0;
EnableNonClientDpiScalingFunc NcDpifunc = 0;
SetThreadDpiAwarenessContextFunc ThreadAwareFunc = 0;

#ifndef _DPI_AWARENESS_CONTEXTS_

typedef enum _DPI_AWARENESS {
	DPI_AWARENESS_INVALID = -1,
	DPI_AWARENESS_UNAWARE = 0,
	DPI_AWARENESS_SYSTEM_AWARE = 1,
	DPI_AWARENESS_PER_MONITOR_AWARE = 2
} DPI_AWARENESS;

#if _MSC_VER<=1500
typedef enum MONITOR_DPI_TYPE {
	MDT_EFFECTIVE_DPI = 0,
	MDT_ANGULAR_DPI = 1,
	MDT_RAW_DPI = 2,
	MDT_DEFAULT = MDT_EFFECTIVE_DPI
} MONITOR_DPI_TYPE;
#endif

#define WM_DPICHANGED                   0x02E0

#define DPI_AWARENESS_CONTEXT_UNAWARE              ((DPI_AWARENESS_CONTEXT)-1)
#define DPI_AWARENESS_CONTEXT_SYSTEM_AWARE         ((DPI_AWARENESS_CONTEXT)-2)
#define DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE    ((DPI_AWARENESS_CONTEXT)-3)
#define DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE_V2 ((DPI_AWARENESS_CONTEXT)-4)
#define DPI_AWARENESS_CONTEXT_UNAWARE_GDISCALED ((DPI_AWARENESS_CONTEXT)-5)
#endif


typedef HRESULT(_stdcall *GetDpiForMonitorFunc)(HMONITOR, MONITOR_DPI_TYPE, UINT *, UINT *);
typedef BOOL(_stdcall *SetProcessDPIAwareFunc)(VOID);

//	ڑĂ郂j^̏i[
struct MONITORS{
	int max;	//	j^[
	RECT* rect;	//	ej^[̍W
	UINT* horizontalDPI;
	UINT* verticalDPI;
	MONITORINFOEX* mi;
	int temp;
	MONITORS(){
		max = 0;
		rect = 0;
	}
};

TCHAR szClassNme[] = TEXT("EnumDisplay2");

//	EBhEvV[W[
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
//	NCAgTCY̕ύX
void SetClientWindowSize(HWND hWnd, int cx, int cy);
//	EnumDisplayMonitors֐烂j^[ɌĂяo֐
BOOL CALLBACK myinfoenumproc(HMONITOR hMon, HDC hdcMon, LPRECT lpMon, LPARAM dwDate);
BOOL CALLBACK myinfoenumproc2(HMONITOR hMon, HDC hdcMon, LPRECT lpMon, LPARAM dwDate);
int win10ver2(void);
int WIN10VER;

int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE hPreInst,
					 TCHAR* lpszCmdLine, int nCmdShow){
	HWND hWnd;
	MSG lpMsg;
	WNDCLASS wc;
	WIN10VER = win10ver2();
	hModUser32 = LoadLibrary(L"User32.dll");
	if (hModUser32){
		if (WIN10VER == 1607)	//	AnniversaryUpdate
			NcDpifunc = (EnableNonClientDpiScalingFunc)GetProcAddress(hModUser32, "EnableNonClientDpiScaling");
		else
			NcDpifunc = 0;
		ThreadAwareFunc = (SetThreadDpiAwarenessContextFunc)GetProcAddress(hModUser32, "SetThreadDpiAwarenessContext");
		if (ThreadAwareFunc){
			if (WIN10VER<1703)
				(*ThreadAwareFunc)(DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE);
			if (1703 <= WIN10VER && WIN10VER<1809)
				(*ThreadAwareFunc)(DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE_V2);
			if (1809 <= WIN10VER)
				(*ThreadAwareFunc)(DPI_AWARENESS_CONTEXT_UNAWARE_GDISCALED);
		}
		else{	//	Windows Vistaȍ~
			SetProcessDPIAwareFunc ProcessAwareFunc = (SetProcessDPIAwareFunc)GetProcAddress(hModUser32, "SetProcessDPIAware");
			if (ProcessAwareFunc)
				(*ProcessAwareFunc)();
		}
	}

	if (!hPreInst) {
		wc.style = CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc = WndProc;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = hInstance;
		wc.hIcon = NULL;
		wc.hCursor = LoadCursor(NULL, IDC_ARROW);
		wc.hbrBackground = (HBRUSH__ *)GetStockObject(WHITE_BRUSH);
		wc.lpszMenuName = NULL;
		wc.lpszClassName = szClassNme;
		if (!RegisterClass(&wc))
			return FALSE;
	}
	hWnd = CreateWindow(szClassNme,
		TEXT("EnumDisplay2"),
		WS_OVERLAPPED	//	I[o[bvEBhE ^Cgo[Ƙg
		| WS_CAPTION	//	^Cgo[Ƙg
		| WS_SYSMENU	//	^Cgo[ɃEBhEj[
		| WS_MINIMIZEBOX,	//	ŏ{^
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL);
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	while (GetMessage(&lpMsg, NULL, 0, 0)) {
		TranslateMessage(&lpMsg);
		DispatchMessage(&lpMsg);
	}
	if (hModUser32)
		FreeLibrary(hModUser32);
	return int(lpMsg.wParam);
}

void ScaleRect(RECT* rect,int scale){
	rect->top *= scale;
	rect->left *= scale;
	rect->bottom *= scale;
	rect->right *= scale;
	rect->top /= 100;
	rect->left /= 100;
	rect->bottom /= 100;
	rect->right /= 100;
}

//	EBhEvV[W[

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam){
	HDC hdc;
	PAINTSTRUCT ps;
	int n;
	TCHAR buf[128];
	static MONITORS mon;	//	ej^[̃TCYi[
	static RECT vs;		//	zXN[TCY
	static double sx = 0.15;
	static double sy = 0.15;
	static int cx = 16;
	static int cy = 16;
	static int cwx = 0;
	static int cwy = 0;
	static int nowDPIx = 96;
	static int nowDPIy = 96;
	static UINT nowScale = 100;
	static HMODULE hMod;
	static GetDpiForMonitorFunc func = 0;
	switch (msg) {
		case WM_CREATE:{
			n = GetSystemMetrics(SM_CMONITORS);	//	j^[擾
			mon.rect = new RECT[n];	//	j^[̍Wi[ϐm
			mon.horizontalDPI = new UINT[n];
			mon.verticalDPI = new UINT[n];
			mon.mi = new MONITORINFOEX[n];
			//	ej^[̍W擾
			EnumDisplayMonitors(NULL, NULL, (MONITORENUMPROC)myinfoenumproc, (LPARAM)&mon);
			//	zXN[TCY擾
			vs.left = GetSystemMetrics(SM_XVIRTUALSCREEN);
			vs.top = GetSystemMetrics(SM_YVIRTUALSCREEN);
			vs.right = vs.left + GetSystemMetrics(SM_CXVIRTUALSCREEN);
			vs.bottom = vs.top + GetSystemMetrics(SM_CYVIRTUALSCREEN);
			hMod = LoadLibrary(L"Shcore.dll");

			func = (GetDpiForMonitorFunc)GetProcAddress(hMod, "GetDpiForMonitor");
			if (func==0)
				FreeLibrary(hMod);

			for (n = 0; n < mon.max; n++){
				POINT    pt;
				pt.x = mon.rect[n].left + 1;
				pt.y = mon.rect[n].top + 1;
				HMONITOR hMonitor = MonitorFromPoint(pt, MONITOR_DEFAULTTONEAREST);
				if (func){
					HRESULT hr = (*func)(hMonitor, MDT_EFFECTIVE_DPI, &mon.horizontalDPI[n], &mon.verticalDPI[n]);
				}else{
					HDC hdc = GetDC(0);	//	fBXNgbvŜHDC
					mon.temp = n;
					EnumDisplayMonitors(hdc, &mon.rect[n], (MONITORENUMPROC)myinfoenumproc2, (LPARAM)&mon);
				}
				mon.mi[n].cbSize = sizeof(MONITORINFOEX);
				GetMonitorInfo(hMonitor,&mon.mi[n]);
			}
			int x = vs.right - vs.left;
			int y = vs.bottom - vs.top;

			HMONITOR hMonitor = MonitorFromWindow(hWnd, MONITOR_DEFAULTTONULL);
			UINT hDPI, vDPI;
			if (func)
				(*func)(hMonitor, MDT_EFFECTIVE_DPI, &hDPI, &vDPI);
			else{
				HDC hdc = GetDC(NULL);	//	fBXNgbv
				hDPI = GetDeviceCaps(hdc, LOGPIXELSX);
				vDPI = GetDeviceCaps(hdc, LOGPIXELSY);
			}
			nowDPIx = hDPI;
			nowDPIy = vDPI;
			nowScale = MulDiv(nowDPIx, 100, 96);
			//	NCAgEBhETCYύX
			SetClientWindowSize(hWnd, (cwx=(cx * 2 + int(double(x*sx))))*nowScale/100, (cwy=(cy * 5 + int(double(y*sy))))*nowScale/100);
			break; 
		}
		case WM_NCCREATE: {	//	Windows 10 Version 1607̂݌Ăяo
			if (NcDpifunc)
				(*NcDpifunc)(hWnd);
			return DefWindowProc(hWnd, msg, wParam, lParam);
		}
		case WM_DPICHANGED:{
			nowDPIx = LOWORD(wParam);
			nowDPIy = HIWORD(wParam);
			nowScale=MulDiv(nowDPIx, 100, 96);
			RECT& rect = *((RECT*)lParam);
			SetClientWindowSize(hWnd, cwx*nowScale / 100, cwy *nowScale / 100);
			RedrawWindow(hWnd, NULL, NULL, RDW_ERASE | RDW_INVALIDATE);
			break;
		}
		case WM_PAINT:{
			HBRUSH hBrush, hOldBrush;
			hdc = BeginPaint(hWnd, &ps);
			int x=vs.right-vs.left;
			int y=vs.bottom-vs.top;
			Rectangle(hdc, cx*nowScale/100, cy*nowScale/100, int(double(x)*sx + cx)*nowScale/100, int(double(y)*sy + cy)*nowScale/100);
			hBrush=CreateSolidBrush(RGB(92, 115, 169));
			hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
			SetBkMode(hdc, TRANSPARENT);	//	ߏ
			SetTextColor(hdc, RGB(255, 255, 255));
			HMONITOR hMonitor = MonitorFromWindow(hWnd, MONITOR_DEFAULTTONULL);
			UINT hDPI, vDPI;
			if (func)
				(*func)(hMonitor, MDT_EFFECTIVE_DPI, &hDPI, &vDPI);
			else{
				HDC hdc = GetDC(NULL);	//	fBXNgbv
				hDPI = GetDeviceCaps(hdc, LOGPIXELSX);
				vDPI = GetDeviceCaps(hdc, LOGPIXELSY);
			}
			TEXTMETRIC metrics;
			GetTextMetrics(hdc, &metrics);
			int height = metrics.tmHeight;
			LOGFONT lf;
			memset(&lf, 0, sizeof(lf));
			lf.lfHeight = height*nowScale;
			lf.lfHeight /= 100;
			HFONT font = CreateFontIndirect(&lf);
			HFONT OldFont = (HFONT)SelectObject(hdc, font);
			for (n = 0; n < mon.max; n++) {
				int x1=int(double(mon.rect[n].left-vs.left)*sx)+cx;
				int y1 = int(double(mon.rect[n].top - vs.top)*sy) + cy;
				int x2 = int(double(mon.rect[n].right - vs.left)*sx) - 1 + cx;
				int y2 = int(double(mon.rect[n].bottom - vs.top)*sy) - 1 + cy;
				RECT rect;

				Rectangle(hdc, x1*nowScale/100, y1*nowScale/100, x2*nowScale/100, y2*nowScale/100);

				_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), TEXT("%s"),mon.mi[n].szDevice);
				rect.left = x1;	rect.right = x2;	rect.top = y1 - 12-16; rect.bottom = y2 + 4-16;
				ScaleRect(&rect, nowScale);
				DrawText(hdc, buf, -1, &rect, DT_CENTER + DT_VCENTER + DT_SINGLELINE);

				_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), TEXT("j^[%i"), n);
				rect.left = x1;	rect.right = x2;	rect.top = y1 -12; rect.bottom = y2 + 4;
				ScaleRect(&rect, nowScale);
				DrawText(hdc, buf, -1, &rect, DT_CENTER + DT_VCENTER + DT_SINGLELINE);

				_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), TEXT("%i*%i"), mon.rect[n].right - mon.rect[n].left, mon.rect[n].bottom - mon.rect[n].top);
				rect.left=x1;	rect.right=x2;	rect.top=y1+8; rect.bottom=y2+24;
				ScaleRect(&rect, nowScale);
				DrawText(hdc, buf, -1, &rect, DT_CENTER + DT_VCENTER + DT_SINGLELINE);
				_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), TEXT("%i,%i"), mon.rect[n].left, mon.rect[n].top);
				rect.left=x1+4;	rect.right=x2;	rect.top=y1+4; rect.bottom=y2;
				ScaleRect(&rect, nowScale);
				DrawText(hdc, buf, -1, &rect, DT_LEFT + DT_TOP + DT_SINGLELINE);

				_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), TEXT("%i,%i"), mon.rect[n].right, mon.rect[n].bottom);
				rect.left=x1;	rect.right=x2-4;	rect.top=y1; rect.bottom=y2-4;
				ScaleRect(&rect, nowScale);
				DrawText(hdc, buf, -1, &rect, DT_RIGHT + DT_BOTTOM + DT_SINGLELINE);
				POINT pt;
				pt.x = mon.rect[n].left + 1;
				pt.y = mon.rect[n].top + 1;
				HMONITOR hMonitor = MonitorFromPoint(pt, MONITOR_DEFAULTTONEAREST);
				if (func){
					HRESULT hr = (*func)(hMonitor, MDT_EFFECTIVE_DPI, &mon.horizontalDPI[n], &mon.verticalDPI[n]);
				}
	
				_stprintf_s(buf, sizeof(buf) / sizeof(TCHAR), TEXT("DPI %i*%i"), mon.horizontalDPI[n], mon.verticalDPI[n]);
				rect.left = x1;	rect.right = x2;	rect.top = y1 + 28; rect.bottom = y2 + 44;
				ScaleRect(&rect, nowScale);
				DrawText(hdc, buf, -1, &rect, DT_CENTER + DT_VCENTER + DT_SINGLELINE);

			}
			SelectObject(hdc, OldFont);
			DeleteObject(font);
			DeleteObject(hBrush);
			EndPaint(hWnd, &ps);
			break; 
		}
		case WM_DESTROY:
			delete [] mon.rect;
			delete[] mon.horizontalDPI;
			delete[] mon.verticalDPI;
			delete[] mon.mi;
			if (func){
				FreeLibrary(hMod);
				hMod = 0;
				func = 0;
			}
			PostQuitMessage(0);
			 break;
		default:
		return(DefWindowProc(hWnd, msg, wParam, lParam));
	}
	return (0L);
}

//	NCAgTCY̕ύX

void SetClientWindowSize(HWND hWnd, int cx, int cy){
	RECT wsize, csize;
	GetWindowRect(hWnd, &wsize);
	GetClientRect(hWnd, &csize);
	int nx, ny;
	nx = (wsize.right - wsize.left) - csize.right + cx;
	ny = (wsize.bottom - wsize.top) - csize.bottom + cy;
	SetWindowPos(hWnd, NULL, 0, 0, nx, ny, SWP_NOMOVE | SWP_NOZORDER);
}

//	EnumDisplayMonitors֐烂j^[ɌĂяo֐

BOOL CALLBACK myinfoenumproc(HMONITOR hMon, HDC hdcMon, LPRECT lpMon, LPARAM dwDate){
	MONITORS* mon = (MONITORS*)dwDate;
	mon->rect[mon->max].bottom = lpMon->bottom;
	mon->rect[mon->max].left = lpMon->left;
	mon->rect[mon->max].top = lpMon->top;
	mon->rect[mon->max].right = lpMon->right;
	++mon->max;
	return TRUE;
}

//	EnumDisplayMonitors֐烂j^[ɌĂяo֐

BOOL CALLBACK myinfoenumproc2(HMONITOR hMon, HDC hdcMon, LPRECT lpMon, LPARAM dwDate){
	MONITORS* mon = (MONITORS*)dwDate;
	mon->horizontalDPI[mon->temp] = GetDeviceCaps(hdcMon, LOGPIXELSX);
	mon->verticalDPI[mon->temp] = GetDeviceCaps(hdcMon, LOGPIXELSY);
	return TRUE;
}

//	DLL̊֐ւ̃|C^^`
typedef void (WINAPI *RtlGetVersion_FUNC)(OSVERSIONINFOEXW*);

int win10ver2(void){
	int ver = 0;
	HMODULE hMod;
	OSVERSIONINFOEXW osw;
	hMod = LoadLibrary(TEXT("ntdll.dll"));
	RtlGetVersion_FUNC func;
	if (hMod){
		func = (RtlGetVersion_FUNC)GetProcAddress(hMod, "RtlGetVersion");
		if (func == 0){
			FreeLibrary(hMod);
			return FALSE;
		}
		ZeroMemory(&osw, sizeof(osw));
		osw.dwOSVersionInfoSize = sizeof(osw);
		func(&osw);
		FreeLibrary(hMod);
		if (osw.dwMajorVersion == 10){
			switch (osw.dwBuildNumber){
			case 10240: ver = 1507; break;
			case 10586: ver = 1511; break;
			case 14393: ver = 1607; break;
			case 15063: ver = 1703; break;
			case 16299: ver = 1709; break;
			case 17134: ver = 1803; break;
			case 17763: ver = 1809; break;
			default: ver = 1809; break;
			}
			return ver;
		}
	}
	return -1;
}